clear all; close all; clc;

% loading results
load NK_financial_3_results
LL11=oo_.MarginalDensity.LaplaceApproximation;
LL12=oo_.MarginalDensity.ModifiedHarmonicMean;
load GK_financial_3_results
LL21=oo_.MarginalDensity.LaplaceApproximation;
LL22=oo_.MarginalDensity.ModifiedHarmonicMean;
load BGG_financial_3_results
LL31=oo_.MarginalDensity.LaplaceApproximation;
LL32=oo_.MarginalDensity.ModifiedHarmonicMean;

% First stage
BR1 = 1;
BR2 = exp(LL21-LL11);
BR3 = exp(LL31-LL11);

p11 = BR1/(BR1+BR2+BR3);
p21 = BR2/(BR1+BR2+BR3);
p31 = BR3/(BR1+BR2+BR3);

fprintf('%16.15f  %16.15f  %16.15f\n',p11,p21,p31)

% Second stage
BR1 = 1;
BR2 = exp(LL22-LL12);
BR3 = exp(LL32-LL12);

p12 = BR1/(BR1+BR2+BR3);
p22 = BR2/(BR1+BR2+BR3);
p32 = BR3/(BR1+BR2+BR3);

fprintf('%16.15f  %16.15f  %16.15f\n',p12,p22,p32)
